import { View, Text } from 'react-native';
import React from 'react';
import { orderSummaryStyle } from './OrderSummaryStyle';
import useProcessPrice from '../../../hooks/useProcessPrice';
import gapStyle from '../../Utilities/CommonStyles/gap.style';

const SelectedProduct = ({ item, index, length }) => {
    const processPrice = useProcessPrice();
    const { variation_meta } = item || {};

    let variationMeta;
    if (variation_meta?.length > 0) {
        variationMeta = JSON.parse(variation_meta.replace(/\\/g, ""));
    }

    return (
        <View
            style={[
                orderSummaryStyle.productCont,
                gapStyle.mb_0_10(index, length),
            ]}
        >
            <View style={orderSummaryStyle.productTitle}>
                <Text style={[orderSummaryStyle.productName, orderSummaryStyle.productNameWidth]}>
                    {`${
                        item.name.length > 25
                            ? `${item.name.substring(0, 25)}...`
                            : item.name
                    } x ${item.quantity}`}
                </Text>
                <Text style={orderSummaryStyle.productName}>
                    {processPrice(Number(item.price) * Number(item.quantity))}
                </Text>
            </View>

            {item.type === "Variable Product" && (
                <Text style={orderSummaryStyle.productVariation}>
                    {Object.keys(variationMeta)?.map(
                        (meta, i) =>
                            `${meta}: ${variationMeta[meta]} ${
                                i ===
                                Object.keys(variationMeta)?.length -
                                    1
                                    ? ""
                                    : "|"
                            } `
                    )}
                </Text>
            )}
        </View>
    );
}

export default SelectedProduct;